<?php

namespace Modules\Vessel\Entities;

use Illuminate\Database\Eloquent\Model;

class Vessel extends Model 
{

    protected $table = 'tbl_vessel';
    public $timestamps = false;

    public function vessel_equipment_type()
    {
        return $this->hasMany('\VesselEquipmentType', 'vessel_id');
    }

    public function vessel_particular()
    {
        return $this->hasMany('Modules\Vessel\Entities\VesselParticular', 'vessel_id');
    }

    public function setting_vessel_type()
    {
        return $this->belongsTo('Modules\Setting\Entities\SettingVesselType', 'vessel_type_id');
    }

    public function vessel_service_report()
    {
        return $this->hasMany('Modules\Vessel\Entities\VesselServiceReport', 'vessel_id');
    }

}